using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    // Struktura za cuvanje tacaka sa koordinatama
    struct Point
    {
        public long X, Y;
        public Point(long x, long y)
        {
            X = x;
            Y = y;
        }
    }

    static void Main()
    {
        // Citanje broja tacaka
        int N = int.Parse(Console.ReadLine());

        // Lista svih tacaka
        List<Point> points = new List<Point>();

        // Ucitavanje tacaka
        for (int i = 0; i < N; i++)
        {
            string[] input = Console.ReadLine().Split();
            long x = long.Parse(input[0]);
            long y = long.Parse(input[1]);
            points.Add(new Point(x, y));
        }

        // Pronalazak skoro konveksnog omotaca
        long result = FindAlmostConvexHullArea(points);

        // Rezultat
        Console.WriteLine(result);
    }

    // Pronalazak površine skoro konveksnog omotaca
    static long FindAlmostConvexHullArea(List<Point> points)
    {
        // Dobijanje konveksnog omotaca
        List<Point> hull = GetConvexHull(points);

        // Površina skoro konveksnog omotaca
        long minArea = long.MaxValue;

        // Prolaz kroz svaku tacku omotaca
        for (int i = 0; i < hull.Count; i++)
        {
            // Kreiranje novog omotaca bez trenutne tacke
            List<Point> reducedHull = new List<Point>(hull);
            reducedHull.RemoveAt(i);

            // Izracunavanje površine
            long area = CalculatePolygonArea(reducedHull);

            // Cuvanje minimalne površine
            if (area < minArea)
            {
                minArea = area;
            }
        }

        return minArea;
    }

    // Pronalazak konveksnog omotaca koristeci Grahamov algoritam
    static List<Point> GetConvexHull(List<Point> points)
    {
        // Sortiranje po x pa y koordinati
        points = points.OrderBy(p => p.X).ThenBy(p => p.Y).ToList();

        List<Point> hull = new List<Point>();

        // Donja strana omotaca
        foreach (Point p in points)
        {
            while (hull.Count >= 2 && Cross(hull[hull.Count - 2], hull[hull.Count - 1], p) <= 0)
            {
                hull.RemoveAt(hull.Count - 1);
            }
            hull.Add(p);
        }

        // Gornja strana omotaca
        int lowerCount = hull.Count;
        for (int i = points.Count - 1; i >= 0; i--)
        {
            Point p = points[i];
            while (hull.Count > lowerCount && Cross(hull[hull.Count - 2], hull[hull.Count - 1], p) <= 0)
            {
                hull.RemoveAt(hull.Count - 1);
            }
            hull.Add(p);
        }

        // Uklanjanje zadnje tacke koja se duplira
        hull.RemoveAt(hull.Count - 1);

        return hull;
    }

    // Izracunavanje površine mnogougla
    static long CalculatePolygonArea(List<Point> polygon)
    {
        long area = 0;

        for (int i = 0; i < polygon.Count; i++)
        {
            Point current = polygon[i];
            Point next = polygon[(i + 1) % polygon.Count];
            area += current.X * next.Y - current.Y * next.X;
        }

        return Math.Abs(area) / 2;
    }

    // Racunanje vektorskog proizvoda
    static long Cross(Point a, Point b, Point c)
    {
        return (b.X - a.X) * (c.Y - a.Y) - (b.Y - a.Y) * (c.X - a.X);
    }
}